<?php
session_start();
//这个就是后台的全部布局都在这  
// 检查登录状态
if (!isset($_SESSION['admin_loggedin'])) {
    header('Location: login.php');
    exit;
}

// 包含配置
require_once __DIR__.'/../config.php';

// 获取服务器基本信息
$server_info = [
    'PHP版本' => phpversion(),
    '服务器软件' => $_SERVER['SERVER_SOFTWARE'],
    '操作系统' => php_uname('s'),
    '内存限制' => ini_get('memory_limit'),
    '上传限制' => ini_get('upload_max_filesize'),
    '磁盘空间' => round(disk_free_space(__DIR__) / 1024 / 1024 / 1024, 2) . ' GB'
];

// 处理表单提交
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 更新基本设置
    if (isset($_POST['site_title'])) {
        $site_config['site_title'] = $_POST['site_title'];
        $site_config['site_desc'] = $_POST['site_desc'];
        $site_config['avatar_url'] = $_POST['avatar_url'];
        $site_config['copyright'] = $_POST['copyright'];
        $site_config['background_type'] = $_POST['background_type'];
        $site_config['background_color1'] = $_POST['background_color1'];
        $site_config['background_color2'] = $_POST['background_color2'];
    }
    
    // 更新应用
    if (isset($_POST['app_name'])) {
        $apps = [];
        $app_names = $_POST['app_name'];
        $app_urls = $_POST['app_url'];
        $app_icon_bgs = $_POST['app_icon_bg'];
        $app_icon_svgs = $_POST['app_icon_svg'];
        
        foreach ($app_names as $index => $name) {
            if (!empty($name)) {
                $apps[] = [
                    'name' => $name,
                    'url' => $app_urls[$index],
                    'icon_bg' => $app_icon_bgs[$index],
                    'icon_svg' => $app_icon_svgs[$index]
                ];
            }
        }
        $site_config['apps'] = $apps;
    }
    
    // 更新页脚链接
    if (isset($_POST['footer_text'])) {
        $footer_links = [];
        $footer_texts = $_POST['footer_text'];
        $footer_urls = $_POST['footer_url'];
        
        foreach ($footer_texts as $index => $text) {
            if (!empty($text)) {
                $footer_links[] = [
                    'text' => $text,
                    'url' => $footer_urls[$index]
                ];
            }
        }
        $site_config['footer_links'] = $footer_links;
    }
    
    // 保存配置
    $config_content = "<?php\n";
    $config_content .= "// 后台登录凭证\n";
    $config_content .= "\$admin_credentials = " . var_export($admin_credentials, true) . ";\n\n";
    $config_content .= "// 前台配置\n";
    $config_content .= "\$site_config = " . var_export($site_config, true) . ";\n";
    $config_content .= "?>";
    
    file_put_contents(__DIR__.'/../config.php', $config_content);
    
    $message = '<div class="notification success"><i class="fas fa-check-circle"></i> 配置已成功保存！</div>';
}

// 获取当前页面
$current_page = isset($_GET['page']) ? $_GET['page'] : 'dashboard';

// 设置默认背景配置
if (!isset($site_config['background_type'])) {
    $site_config['background_type'] = 'none';
    $site_config['background_color1'] = '#4361ee';
    $site_config['background_color2'] = '#3a56c8';
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>刀客源码导航 - 后台管理</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #5e72e4;
            --primary-dark: #3a56c8;
            --secondary: #3f37c9;
            --success: #4cc9f0;
            --danger: #f72585;
            --warning: #f8961e;
            --info: #4895ef;
            --light: #f8f9fa;
            --dark: #212529;
            --gray: #6c757d;
            --gray-light: #e9ecef;
            --white: #ffffff;
            --sidebar-width: 260px;
            --sidebar-collapsed-width: 80px;
            --header-height: 60px;
            --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }

        body {
            background-color: #f5f7fb;
            color: var(--dark);
            line-height: 1.6;
            min-height: 100vh;
            overflow-x: hidden;
        }

        a {
            text-decoration: none;
            color: inherit;
        }

        /* 布局 */
        .admin-container {
            display: flex;
            min-height: 100vh;
        }

        /* 侧边栏 */
        .sidebar {
            width: var(--sidebar-width);
            background: var(--white);
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
            transition: var(--transition);
            position: fixed;
            height: 100vh;
            z-index: 100;
            overflow-y: auto;
            transform: translateX(-100%);
        }

        .sidebar.active {
            transform: translateX(0);
        }

        .sidebar-header {
            padding: 1rem;
            border-bottom: 1px solid var(--gray-light);
            height: var(--header-height);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .sidebar-title {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--primary);
            white-space: nowrap;
        }

        .sidebar-menu {
            padding: 1rem 0;
        }

        .menu-item {
            padding: 0.75rem 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            color: var(--gray);
            transition: var(--transition);
            border-left: 3px solid transparent;
        }

        .menu-item:hover {
            color: var(--primary);
            background: rgba(67, 97, 238, 0.1);
        }

        .menu-item.active {
            color: var(--primary);
            background: rgba(67, 97, 238, 0.1);
            border-left: 3px solid var(--primary);
        }

        .menu-item i {
            font-size: 1.1rem;
            width: 24px;
            text-align: center;
        }

        /* 主内容区 */
        .main-content {
            flex: 1;
            transition: var(--transition);
            min-height: 100vh;
            width: 100%;
        }

        /* 头部 */
        .admin-header {
            height: var(--header-height);
            background: var(--white);
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 1rem;
            position: sticky;
            top: 0;
            z-index: 90;
        }

        .header-left {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .toggle-sidebar {
            background: none;
            border: none;
            font-size: 1.25rem;
            color: var(--gray);
            cursor: pointer;
            transition: var(--transition);
            outline: none;
        }

        .toggle-sidebar:hover {
            color: var(--primary);
        }

        .header-title {
            font-size: 1.1rem;
            font-weight: 600;
        }

        .header-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .header-action {
            background: none;
            border: none;
            font-size: 1.1rem;
            color: var(--gray);
            cursor: pointer;
            transition: var(--transition);
            outline: none;
        }

        .header-action:hover {
            color: var(--primary);
        }

        .user-avatar {
            width: 36px;
            height: 36px;
            border-radius: 50%;
            background: var(--primary);
            color: var(--white);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            overflow: hidden;
        }

        .user-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        /* 内容区 */
        .content-wrapper {
            padding: 1rem;
        }

        /* 统计卡片 */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .stat-card {
            background: var(--white);
            border-radius: 12px;
            padding: 1rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            transition: var(--transition);
        }

        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
        }

        .stat-icon {
            width: 40px;
            height: 40px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
            margin-bottom: 0.75rem;
        }

        .stat-icon.primary {
            background: rgba(67, 97, 238, 0.1);
            color: var(--primary);
        }

        .stat-icon.success {
            background: rgba(76, 201, 240, 0.1);
            color: var(--success);
        }

        .stat-icon.warning {
            background: rgba(248, 150, 30, 0.1);
            color: var(--warning);
        }

        .stat-icon.danger {
            background: rgba(247, 37, 133, 0.1);
            color: var(--danger);
        }

        .stat-title {
            font-size: 0.8rem;
            color: var(--gray);
            margin-bottom: 0.5rem;
        }

        .stat-value {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .stat-change {
            font-size: 0.75rem;
            display: flex;
            align-items: center;
            gap: 0.25rem;
        }

        .stat-change.up {
            color: var(--success);
        }

        .stat-change.down {
            color: var(--danger);
        }

        /* 信息卡片 */
        .info-card {
            background: var(--white);
            border-radius: 12px;
            padding: 1.25rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            margin-bottom: 1.5rem;
        }

        .info-card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--gray-light);
        }

        .info-card-title {
            font-size: 1.1rem;
            font-weight: 600;
            color: var(--primary);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .info-card-title i {
            font-size: 1rem;
        }

        /* 表格 */
        .info-table {
            width: 100%;
            border-collapse: collapse;
        }

        .info-table th, .info-table td {
            padding: 0.75rem;
            text-align: left;
            border-bottom: 1px solid var(--gray-light);
        }

        .info-table th {
            font-weight: 600;
            color: var(--gray);
            width: 30%;
        }

        /* 表单卡片 */
        .form-card {
            background: var(--white);
            border-radius: 12px;
            padding: 1.25rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            margin-bottom: 1.5rem;
        }

        .form-group {
            margin-bottom: 1rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
            font-weight: 500;
            color: var(--dark);
        }

        .form-control {
            width: 100%;
            padding: 0.75rem 1rem;
            border: 1px solid var(--gray-light);
            border-radius: 8px;
            font-size: 0.9rem;
            transition: var(--transition);
            background-color: var(--white);
        }

        .form-control:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.2);
            outline: none;
        }

        textarea.form-control {
            min-height: 100px;
            resize: vertical;
        }

        /* 颜色选择器 */
        .color-picker {
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .color-input {
            width: 60px;
            height: 36px;
            padding: 0;
            border: 1px solid var(--gray-light);
            border-radius: 6px;
            cursor: pointer;
        }

        .color-value {
            font-size: 0.85rem;
            color: var(--gray);
        }

        /* 背景预览 */
        .bg-preview {
            width: 100%;
            height: 120px;
            border-radius: 8px;
            margin-top: 0.5rem;
            overflow: hidden;
            position: relative;
            border: 1px solid var(--gray-light);
        }

        /* 应用网格 */
        .apps-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(240px, 1fr));
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .app-card {
            background: var(--white);
            border-radius: 12px;
            padding: 1rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            transition: var(--transition);
            display: flex;
            align-items: center;
            gap: 0.75rem;
            position: relative;
        }

        .app-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 15px rgba(0, 0, 0, 0.1);
        }

        .app-icon {
            width: 40px;
            height: 40px;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
            color: var(--white);
            flex-shrink: 0;
        }

        .app-info {
            flex: 1;
            min-width: 0;
        }

        .app-name {
            font-weight: 600;
            margin-bottom: 0.25rem;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            font-size: 0.95rem;
}

        .app-url {
            font-size: 0.8rem;
            color: var(--gray);
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .app-actions {
            display: flex;
            gap: 0.5rem;
        }

        /* 页脚链接项 */
        .footer-links-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 1rem;
            margin-bottom: 1rem;
        }

        .footer-link-item {
            background: var(--light);
            border-radius: 8px;
            padding: 1rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .footer-link-item .form-group {
            flex: 1;
            margin-bottom: 0;
        }

        .footer-link-actions {
            display: flex;
            gap: 0.5rem;
        }

        /* 模态框 */
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            z-index: 1000;
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: var(--white);
            border-radius: 12px;
            width: 95%;
            max-width: 500px;
            max-height: 90vh;
            overflow-y: auto;
            padding: 1.25rem;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            animation: modalFadeIn 0.3s ease;
            margin: 0 1rem;
        }

        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--gray-light);
        }

        .modal-title {
            font-size: 1.1rem;
            font-weight: 600;
        }

        .modal-close {
            background: none;
            border: none;
            font-size: 1.5rem;
            cursor: button;
            color: var(--gray);
            outline: none;
        }

        /* 作者卡片 */
        .author-card {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1.5rem;
            flex-direction: column;
            text-align: center;
        }

        .author-avatar {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid var(--primary);
            padding: 3px;
        }

        .author-info {
            flex: 1;
            width: 100%;
        }

        .author-name {
            font-size: 1.25rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .author-bio {
            color: var(--gray);
            margin-bottom: 1rem;
            font-size: 0.9rem;
        }

        .author-social {
            display: flex;
            gap: 1rem;
            justify-content: center;
        }

        .social-link {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: var(--gray-light);
            display: flex;
            align-items: center;
            justify-content: center;
            transition: var(--transition);
            font-size: 0.9rem;
        }

        .social-link:hover {
            background: var(--primary);
            color: var(--white);
        }

        /* 关于系统卡片 */
        .about-card {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 1rem;
        }

        .about-item {
            background: var(--white);
            border-radius: 12px;
            padding: 1.25rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }

        .about-title {
            font-size: 1rem;
            font-weight: 600;
            color: var(--primary);
            margin-bottom: 0.75rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .about-content {
            line-height: 1.6;
            font-size: 0.9rem;
        }

        .about-content p {
            margin-bottom: 0.5rem;
        }

        /* 按钮 */
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.75rem 1.25rem;
            border-radius: 8px;
            font-weight: 600;
            font-size: 0.9rem;
            cursor: pointer;
            transition: var(--transition);
            border: none;
            outline: none;
        }

        .btn-primary {
            background: var(--primary);
            color: var(--white);
        }

        .btn-primary:hover {
            background: var(--primary-dark);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        }

        .btn-success {
            background: var(--success);
            color: var(--white);
        }

        .btn-success:hover {
            background: #3ab7d9;
            box-shadow: 0 5px 15px rgba(76, 201, 240, 0.3);
        }

        .btn-danger {
            background: var(--danger);
            color: var(--white);
        }

        .btn-danger:hover {
            background: #e5177a;
            box-shadow: 0 5px 15px rgba(247, 37, 133, 0.3);
        }

        .btn-outline {
            background: transparent;
            color: var(--primary);
            border: 1px solid var(--primary);
        }

        .btn-outline:hover {
            background: rgba(67, 97, 238, 0.1);
        }

        .btn-sm {
            padding: 0.5rem 0.75rem;
            font-size: 0.8rem;
        }

        .btn-icon {
            width: 2.25rem;
            height: 2.25rem;
            border-radius: 50%;
            padding: 0;
            justify-content: center;
        }

        /* 通知 */
        .notification {
            padding: 0.75rem 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-weight: 500;
            font-size: 0.9rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }

        .notification i {
            font-size: 1rem;
        }

        .notification.success {
            background: rgba(76, 201, 240, 0.15);
            color: #0d8db8;
            border-left: 4px solid var(--success);
        }

        /* 响应式 */
        @media (min-width: 768px) {
            .content-wrapper {
                padding: 1.5rem;
            }
            
            .stats-grid {
                grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            }
            
            .author-card {
                flex-direction: row;
                text-align: left;
            }
            
            .author-social {
                justify-content: flex-start;
            }
        }

        @media (min-width: 992px) {
            .sidebar {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: var(--sidebar-width);
            }
            
            .toggle-sidebar {
                display: none;
            }
            
            .content-wrapper {
                padding: 2rem;
            }
            
            .stats-grid {
                grid-template-columns: repeat(auto-fill, minmax(240px, 1fr));
            }
            
            .info-card, .form-card {
                padding: 1.5rem;
            }
            
            .info-card-title, .modal-title {
                font-size: 1.25rem;
            }
            
            .author-card {
                flex-direction: row;
            }
        }

        /* 动画 */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        @keyframes modalFadeIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>
    <!-- 侧边栏遮罩 -->
    <div class="sidebar-overlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 99;"></div>
    
    <div class="admin-container">
        <!-- 侧边栏 -->
        <div class="sidebar">
            <div class="sidebar-header">
                <h1 class="sidebar-title">刀客源码导航后台管理</h1>
            </div>
            <div class="sidebar-menu">
                <a href="?page=dashboard" class="menu-item <?php echo $current_page === 'dashboard' ? 'active' : ''; ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>控制面板</span>
                </a>
                <a href="?page=settings" class="menu-item <?php echo $current_page === 'settings' ? 'active' : ''; ?>">
                    <i class="fas fa-cog"></i>
                    <span>基本设置</span>
                </a>
                <a href="?page=apps" class="menu-item <?php echo $current_page === 'apps' ? 'active' : ''; ?>">
                    <i class="fas fa-th"></i>
                    <span>网站管理</span>
                </a>
                <a href="?page=footer" class="menu-item <?php echo $current_page === 'footer' ? 'active' : ''; ?>">
                    <i class="fas fa-link"></i>
                    <span>页脚设置</span>
                </a>
                <a href="?page=about" class="menu-item <?php echo $current_page === 'about' ? 'active' : ''; ?>">
                    <i class="fas fa-info-circle"></i>
                    <span>关于程序</span>
                </a>
                <a href="logout.php" class="menu-item">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>退出登录</span>
                </a>
            </div>
        </div>
        
        <!-- 主内容区 -->
        <div class="main-content">
            <!-- 头部 -->
            <div class="admin-header">
                <div class="header-left">
                    <button class="toggle-sidebar" onclick="toggleSidebar()">
                        <i class="fas fa-bars"></i>
                    </button>
                    <h1 class="header-title">
                        <?php 
                            switch($current_page) {
                                case 'dashboard': echo '控制面板'; break;
                                case 'settings': echo '基本设置'; break;
                                case 'apps': echo '网站管理'; break;
                                case 'footer': echo '页脚设置'; break;
                                case 'about': echo '关于程序'; break;
                                default: echo '控制面板';
                            }
                        ?>
                    </h1>
                </div>
                <div class="header-actions">
                    <button class="header-action" onclick="window.open('../', '_blank')" title="访问前台">
                        <i class="fas fa-home"></i>
                    </button>
                    <div class="user-avatar">
                        <?php if (strpos($site_config['avatar_url'], 'data:image') === 0): ?>
                            <img src="<?php echo htmlspecialchars($site_config['avatar_url']); ?>" alt="用户头像">
                        <?php else: ?>
                            <img src="<?php echo htmlspecialchars($site_config['avatar_url']); ?>" alt="用户头像" onerror="this.src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJub25lIiBstHJva2U9IiNmZmZmZmYiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIiBjbGFzcz0ibHVjaWRlIGx1Y2lkZS11c2VyIj48cGF0aCBkPSJNMTkgMjF2LTJhNCA0IDAgMCAwLTQtNEg5YTQgNCAwIDAgMC00IDR2MiIvPjxjaXJjbGUgY3g9IjEyIiBjeT0iNyIgcj0iNCIvPjwvc3ZnPg=='">
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- 内容区 -->
            <div class="content-wrapper">
                <?php if ($message) echo $message; ?>
                
                <?php if ($current_page === 'dashboard'): ?>
                    <!-- 控制面板 -->
                    <div class="stats-grid">
                        <div class="stat-card">
                            <div class="stat-icon primary">
                                <i class="fas fa-th"></i>
                            </div>
                            <h3 class="stat-title">应用数量</h3>
                            <div class="stat-value"><?php echo count($site_config['apps']); ?></div>
                            <div class="stat-change up">
                                <i class="fas fa-arrow-up"></i>
                                <span>较上月 +2</span>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon success">
                                <i class="fas fa-users"></i>
                            </div>
                            <h3 class="stat-title">今日访问</h3>
                            <div class="stat-value">1,248</div>
                            <div class="stat-change up">
                                <i class="fas fa-arrow-up"></i>
                                <span>较昨日 +12%</span>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon warning">
                                <i class="fas fa-eye"></i>
                            </div>
                            <h3 class="stat-title">总浏览量</h3>
                            <div class="stat-value">24,587</div>
                            <div class="stat-change up">
                                <i class="fas fa-arrow-up"></i>
                                <span>较上周 +5%</span>
                            </div>
                        </div>
                        <div class="stat-card">
                            <div class="stat-icon danger">
                                <i class="fas fa-server"></i>
                            </div>
                            <h3 class="stat-title">服务器负载</h3>
                            <div class="stat-value">12%</div>
                            <div class="stat-change down">
                                <i class="fas fa-arrow-down"></i>
                                <span>较昨日 -3%</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- 作者介绍 -->
                    <div class="info-card">
                        <div class="info-card-header">
                            <h2 class="info-card-title"><i class="fas fa-user"></i>分享者</h2>
                        </div>
                        <div class="author-card">
                            <img src="<?php echo htmlspecialchars($site_config['avatar_url']); ?>" alt="作者头像" class="author-avatar" onerror="this.src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJub25lIiBzdHJva2U9IiM0MzYxZWUiIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIiBjbGFzcz0ibHVjaWRlIGx1Y2lkZS11c2VyIj48cGF0aCBkPSJNMTkgMjF2LTJhNCA0IDAgMCAwLTQtNEg5YTQgNCA0IDAgMCAwLTQgNHYyIi8+PGNpcmNsZSBjeD0iMTIiIGN5PSI3IiByPSI0Ii8+PC9zdmc+'">
                            <div class="author-info">
                                <h3 class="author-name">刀客源码网：www.dkewl.com</h3>
                                <p class="author-bio">专注于打造简洁高效的个人导航系统。</p>
                                <div class="author-social">
                                    <a href="#" class="social-link"><i class="fab fa-github"></i></a>
                                    <a href="#" class="social-link"><i class="fab fa-twitter"></i></a>
                                    <a href="#" class="social-link"><i class="fab fa-weixin"></i></a>
                                    <a href="#" class="social-link"><i class="fas fa-envelope"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- 服务器信息 -->
                    <div class="info-card">
                        <div class="info-card-header">
                            <h2 class="info-card-title"><i class="fas fa-server"></i> 服务器信息</h2>
                        </div>
                        <table class="info-table">
                            <tbody>
                                <?php foreach ($server_info as $key => $value): ?>
                                <tr>
                                    <th><?php echo $key; ?></th>
                                    <td><?php echo htmlspecialchars($value); ?></td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                <?php elseif ($current_page === 'settings'): ?>
                    <!-- 基本设置 -->
                    <form method="POST">
                        <div class="form-card">
                            <div class="info-card-header">
                                <h2 class="info-card-title"><i class="fas fa-cog"></i> 基本设置</h2>
                            </div>
                            <div class="form-group">
                                <label class="form-label">网站标题</label>
                                <input type="text" class="form-control" name="site_title" value="<?php echo htmlspecialchars($site_config['site_title']); ?>" required>
                            </div>
                            <div class="form-group">
                                <label class="form-label">网站描述</label>
                                <input type="text" class="form-control" name="site_desc" value="<?php echo htmlspecialchars($site_config['site_desc']); ?>" required>
                            </div>
                            <div class="form-group">
                                <label class="form-label">头像URL (Base64或网络地址)</label>
                                <textarea class="form-control" name="avatar_url" required><?php echo htmlspecialchars($site_config['avatar_url']); ?></textarea>
                            </div>
                            <div class="form-group">
                                <label class="form-label">版权信息</label>
                                <input type="text" class="form-control" name="copyright" value="<?php echo htmlspecialchars($site_config['copyright']); ?>" required>
                            </div>
                            
                            <!-- 动态背景设置 -->
                            <div class="form-group">
                                <label class="form-label">背景类型</label>
                                <select class="form-control" name="background_type" id="backgroundType" onchange="updateBgPreview()">
                                    <option value="none" <?php echo $site_config['background_type'] === 'none' ? 'selected' : ''; ?>>无背景</option>
                                    <option value="particles" <?php echo $site_config['background_type'] === 'particles' ? 'selected' : ''; ?>>粒子效果</option>
                                    <option value="waves" <?php echo $site_config['background_type'] === 'waves' ? 'selected' : ''; ?>>波浪效果</option>
                                    <option value="stars" <?php echo $site_config['background_type'] === 'stars' ? 'selected' : ''; ?>>星空效果</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label class="form-label">背景颜色一</label>
                                <div class="color-picker">
                                    <input type="color" class="color-input" name="background_color1" value="<?php echo htmlspecialchars($site_config['background_color1']); ?>" onchange="updateBgPreview()">
                                    <span class="color-value"><?php echo htmlspecialchars($site_config['background_color1']); ?></span>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label class="form-label">背景颜色二</label>
                                <div class="color-picker">
                                    <input type="color" class="color-input" name="background_color2" value="<?php echo htmlspecialchars($site_config['background_color2']); ?>" onchange="updateBgPreview()">
                                    <span class="color-value"><?php echo htmlspecialchars($site_config['background_color2']); ?></span>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label class="form-label">背景预览</label>
                                <div class="bg-preview" id="bgPreview"></div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> 保存设置
                            </button>
                        </div>
                    </form>
                    
                <?php elseif ($current_page === 'apps'): ?>
                    <!-- 网站管理 -->
                    <div class="info-card">
                        <div class="info-card-header">
                            <h2 class="info-card-title"><i class="fas fa-th"></i> 网站管理</h2>
                            <button class="btn btn-success" onclick="openAddAppModal()">
                                <i class="fas fa-plus"></i> 添加网站
                            </button>
                        </div>
                        <div class="apps-grid">
                            <?php foreach ($site_config['apps'] as $index => $app): ?>
                            <div class="app-card">
                                <div class="app-icon" style="background: <?php echo htmlspecialchars($app['icon_bg']); ?>">
                                    <?php echo $app['icon_svg']; ?>
                                </div>
                                <div class="app-info">
                                    <h3 class="app-name"><?php echo htmlspecialchars($app['name']); ?></h3>
                                    <p class="app-url"><?php echo htmlspecialchars($app['url']); ?></p>
                                </div>
                                <div class="app-actions">
                                    <button class="btn btn-primary btn-sm" onclick="openEditAppModal(<?php echo $index; ?>)">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-danger btn-sm" onclick="confirmDeleteApp(<?php echo $index; ?>)">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    
                    <!-- 添加应用模态框 -->
                    <div class="modal" id="addAppModal">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h3 class="modal-title">添加新网站</h3>
                                <button class="modal-close" onclick="closeModal('addAppModal')">&times;</button>
                            </div>
                            <form id="addAppForm" method="POST">
                                <input type="hidden" name="app_name[]" value="">
                                <input type="hidden" name="app_url[]" value="">
                                <input type="hidden" name="app_icon_bg[]" value="">
                                <input type="hidden" name="app_icon_svg[]" value="">
                                
                                <div class="form-group">
                                    <label class="form-label">网站名称</label>
                                    <input type="text" class="form-control" id="newAppName" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">网站URL</label>
                                    <input type="text" class="form-control" id="newAppUrl" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">图标背景 (CSS gradient)</label>
                                    <input type="text" class="form-control" id="newAppIconBg" placeholder="例如: linear-gradient(135deg, #4361ee, #3a56c8)" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">图标SVG代码</label>
                                    <textarea class="form-control" id="newAppIconSvg" rows="4" required placeholder="<svg>...</svg>"></textarea>
                                </div>
                                <div class="form-group text-right">
                                    <button type="button" class="btn btn-outline" onclick="closeModal('addAppModal')">取消</button>
                                    <button type="button" class="btn btn-primary" onclick="submitAddAppForm()">保存</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    
                    <!-- 编辑应用模态框 -->
                    <div class="modal" id="editAppModal">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h3 class="modal-title">编辑网站</h3>
                                <button class="modal-close" onclick="closeModal('editAppModal')">&times;</button>
                            </div>
                            <form id="editAppForm" method="POST">
                                <input type="hidden" name="app_name[]" value="">
                                <input type="hidden" name="app_url[]" value="">
                                <input type="hidden" name="app_icon_bg[]" value="">
                                <input type="hidden" name="app_icon_svg[]" value="">
                                <input type="hidden" id="editAppIndex" value="">
                                
                                <div class="form-group">
                                    <label class="form-label">网站名称</label>
                                    <input type="text" class="form-control" id="editAppName" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">网站URL</label>
                                    <input type="text" class="form-control" id="editAppUrl" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">图标背景 (CSS gradient)</label>
                                    <input type="text" class="form-control" id="editAppIconBg" required>
                                </div>
                                <div class="form-group">
                                    <label class="form-label">图标SVG代码</label>
                                    <textarea class="form-control" id="editAppIconSvg" rows="4" required></textarea>
                                </div>
                                <div class="form-group text-right">
                                    <button type="button" class="btn btn-outline" onclick="closeModal('editAppModal')">取消</button>
                                    <button type="button" class="btn btn-primary" onclick="submitEditAppForm()">保存</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    
                <?php elseif ($current_page === 'footer'): ?>
                    <!-- 页脚设置 -->
                    <form method="POST">
                        <div class="form-card">
                            <div class="info-card-header">
                                <h2 class="info-card-title"><i class="fas fa-link"></i> 页脚链接</h2>
                                <button type="button" class="btn btn-success" onclick="addFooterLink()">
                                    <i class="fas fa-plus"></i> 添加链接
                                </button>
                            </div>
                            <div id="footerLinks" class="footer-links-grid">
                                <?php foreach ($site_config['footer_links'] as $index => $link): ?>
                                <div class="footer-link-item">
                                    <div class="form-group">
                                        <label class="form-label">链接文本</label>
                                        <input type="text" class="form-control" name="footer_text[]" value="<?php echo htmlspecialchars($link['text']); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label class="form-label">链接地址</label>
                                        <input type="text" class="form-control" name="footer_url[]" value="<?php echo htmlspecialchars($link['url']); ?>">
                                    </div>
                                    <div class="footer-link-actions">
                                        <button type="button" class="btn btn-danger btn-icon" onclick="removeFooterLink(this)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                            <div class="text-right">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> 保存设置
                                </button>
                            </div>
                        </div>
                    </form>
                    
                <?php elseif ($current_page === 'about'): ?>
                    <!-- 关于系统 -->
                    <div class="about-card">
                        <div class="about-item">
                            <h3 class="about-title"><i class="fas fa-info-circle"></i> 程序信息</h3>
                            <div class="about-content">
                                <p><strong>名称：</strong> 刀客源码导航</p>
                                <p><strong>版本：</strong> 1.0.0</p>
                                <p><strong>最后更新：</strong> <?php echo date('Y-m-d'); ?></p>
                                <p><strong>开发者：</strong> 听风</p>
                                <p><strong>留言：</strong> 一个好的程序员应该是那种过单行线都要往两边看的人</p>
                            </div>
                        </div>
                        
                        <div class="about-item">
                            <h3 class="about-title"><i class="fas fa-cog"></i> 系统功能</h3>
                            <div class="about-content">
                                <p><i class="fas fa-check-circle" style="color: var(--success);"></i> 简洁高效的后台管理</p>
                                <p><i class="fas fa-check-circle" style="color: var(--success);"></i> 响应式设计，适配各种设备</p>
                                <p><i class="fas fa-check-circle" style="color: var(--success);"></i> 快速添加和管理网站</p>
                                <p><i class="fas fa-check-circle" style="color: var(--success);"></i> 自定义页脚链接</p>
                                <p><i class="fas fa-check-circle" style="color: var(--success);"></i> 动态背景选择</p>
                            </div>
                        </div>
                        
                        <div class="about-item">
                            <h3 class="about-title"><i class="fas fa-server"></i> 系统要求</h3>
                            <div class="about-content">
                                <p><i class="fas fa-check" style="color: var(--primary);"></i> PHP 7.4+</p>
                                <p><i class="fas fa-check" style="color: var(--primary);"></i> 无需数据库很方便我喜欢就对了</p>
                                <p><i class="fas fa-check" style="color: var(--primary);"></i> 文件存储配置</p>
                                <p><i class="fas fa-check" style="color: var(--primary);"></i> 现代浏览器支持</p>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script>
        // 切换侧边栏
        function toggleSidebar() {
            const sidebar = document.querySelector('.sidebar');
            const overlay = document.querySelector('.sidebar-overlay');
            
            sidebar.classList.toggle('active');
            
            if (sidebar.classList.contains('active')) {
                overlay.style.display = 'block';
                setTimeout(() => overlay.style.opacity = '1', 10);
            } else {
                overlay.style.opacity = '0';
                setTimeout(() => overlay.style.display = 'none', 300);
            }
        }
        
        // 点击遮罩关闭侧边栏
        document.querySelector('.sidebar-overlay').addEventListener('click', function() {
            toggleSidebar();
        });
        
        // 添加页脚链接
        function addFooterLink() {
            const footerLinks = document.getElementById('footerLinks');
            const newLink = document.createElement('div');
            newLink.className = 'footer-link-item';
            newLink.style.animation = 'fadeIn 0.3s ease';
            newLink.innerHTML = `
                <div class="form-group">
                    <label class="form-label">链接文本</label>
                    <input type="text" class="form-control" name="footer_text[]">
                </div>
                <div class="form-group">
                    <label class="form-label">链接地址</label
                    <input type="text" class="form-control" name="footer_url[]">
                </div>
                <div class="footer-link-actions">
                    <button type="button" class="btn btn-danger btn-icon" onclick="removeFooterLink(this)">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            `;
            footerLinks.appendChild(newLink);
        }
        
        // 删除页脚链接
        function removeFooterLink(button) {
            const item = button.closest('.footer-link-item');
            item.style.opacity = '0';
            item.style.height = '0';
            item.style.margin = '0';
            setTimeout(() => item.remove(), 300);
        }
        
        // 打开添加应用模态框
        function openAddAppModal() {
            document.getElementById('addAppModal').style.display = 'flex';
            document.body.style.overflow = 'hidden';
        }
        
        // 打开编辑应用模态框
        function openEditAppModal(index) {
            const apps = <?php echo json_encode($site_config['apps']); ?>;
            const app = apps[index];
            
            document.getElementById('editAppName').value = app.name;
            document.getElementById('editAppUrl').value = app.url;
            document.getElementById('editAppIconBg').value = app.icon_bg;
            document.getElementById('editAppIconSvg').value = app.icon_svg;
            document.getElementById('editAppIndex').value = index;
            
            document.getElementById('editAppModal').style.display = 'flex';
            document.body.style.overflow = 'hidden';
        }
        
        // 关闭模态框
        function closeModal(modalId) {
            document.getElementById(modalId).style.display = 'none';
            document.body.style.overflow = 'auto';
        }
        
        // 提交添加应用表单
        function submitAddAppForm() {
            const name = document.getElementById('newAppName').value;
            const url = document.getElementById('newAppUrl').value;
            const iconBg = document.getElementById('newAppIconBg').value;
            const iconSvg = document.getElementById('newAppIconSvg').value;
            
            if (!name || !url || !iconBg || !iconSvg) {
                alert('请填写所有必填字段');
                return;
            }
            
            // 更新隐藏的表单字段
            document.querySelector('#addAppForm input[name="app_name[]"]').value = name;
            document.querySelector('#addAppForm input[name="app_url[]"]').value = url;
            document.querySelector('#addAppForm input[name="app_icon_bg[]"]').value = iconBg;
            document.querySelector('#addAppForm input[name="app_icon_svg[]"]').value = iconSvg;
            
            // 提交表单
            document.getElementById('addAppForm').submit();
        }
        
        // 提交编辑应用表单
        function submitEditAppForm() {
            const index = document.getElementById('editAppIndex').value;
            const name = document.getElementById('editAppName').value;
            const url = document.getElementById('editAppUrl').value;
            const iconBg = document.getElementById('editAppIconBg').value;
            const iconSvg = document.getElementById('editAppIconSvg').value;
            
            if (!name || !url || !iconBg || !iconSvg) {
                alert('请填写所有必填字段');
                return;
            }
            
            // 更新隐藏的表单字段
            document.querySelector('#editAppForm input[name="app_name[]"]').value = name;
            document.querySelector('#editAppForm input[name="app_url[]"]').value = url;
            document.querySelector('#editAppForm input[name="app_icon_bg[]"]').value = iconBg;
            document.querySelector('#editAppForm input[name="app_icon_svg[]"]').value = iconSvg;
            
            // 提交表单
            document.getElementById('editAppForm').submit();
        }
        
        // 确认删除应用
        function confirmDeleteApp(index) {
            if (confirm('确定要删除这个网站吗？')) {
                // 创建一个表单来提交删除请求
                const form = document.createElement('form');
                form.method = 'POST';
                form.style.display = 'none';
                
                // 克隆现有的应用数组
                const apps = <?php echo json_encode($site_config['apps']); ?>;
                
                // 移除指定索引的应用
                apps.splice(index, 1);
                
                // 添加隐藏字段
                apps.forEach((app, i) => {
                    addHiddenField(form, 'app_name[]', app.name);
                    addHiddenField(form, 'app_url[]', app.url);
                    addHiddenField(form, 'app_icon_bg[]', app.icon_bg);
                    addHiddenField(form, 'app_icon_svg[]', app.icon_svg);
                });
                
                // 添加页脚链接
                const footerLinks = <?php echo json_encode($site_config['footer_links']); ?>;
                footerLinks.forEach(link => {
                    addHiddenField(form, 'footer_text[]', link.text);
                    addHiddenField(form, 'footer_url[]', link.url);
                });
                
                // 添加基本设置
                addHiddenField(form, 'site_title', '<?php echo addslashes($site_config['site_title']); ?>');
                addHiddenField(form, 'site_desc', '<?php echo addslashes($site_config['site_desc']); ?>');
                addHiddenField(form, 'avatar_url', '<?php echo addslashes($site_config['avatar_url']); ?>');
                addHiddenField(form, 'copyright', '<?php echo addslashes($site_config['copyright']); ?>');
                addHiddenField(form, 'background_type', '<?php echo addslashes($site_config['background_type']); ?>');
                addHiddenField(form, 'background_color1', '<?php echo addslashes($site_config['background_color1']); ?>');
                addHiddenField(form, 'background_color2', '<?php echo addslashes($site_config['background_color2']); ?>');
                
                document.body.appendChild(form);
                form.submit();
            }
        }
        
        // 添加隐藏字段到表单
        function addHiddenField(form, name, value) {
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = name;
            input.value = value;
            form.appendChild(input);
        }
        
        // 更新背景预览
        function updateBgPreview() {
            const bgType = document.getElementById('backgroundType').value;
            const color1 = document.querySelector('input[name="background_color1"]').value;
            const color2 = document.querySelector('input[name="background_color2"]').value;
            const preview = document.getElementById('bgPreview');
            
            // 更新颜色值显示
            document.querySelector('.color-picker .color-value').textContent = color1;
            document.querySelectorAll('.color-picker .color-value')[1].textContent = color2;
            
            // 清除之前的预览
            preview.innerHTML = '';
            preview.style.background = '';
            
            if (bgType === 'none') {
                preview.style.background = '#f5f7fb';
                return;
            }
            
            if (bgType === 'particles') {
                // 粒子效果预览
                preview.style.background = `linear-gradient(135deg, ${color1}, ${color2})`;
                const canvas = document.createElement('canvas');
                canvas.width = preview.offsetWidth;
                canvas.height = preview.offsetHeight;
                preview.appendChild(canvas);
                
                // 简单粒子效果
                const ctx = canvas.getContext('2d');
                const particles = [];
                
                for (let i = 0; i < 20; i++) {
                    particles.push({
                        x: Math.random() * canvas.width,
                        y: Math.random() * canvas.height,
                        size: Math.random() * 3 + 1,
                        speedX: Math.random() * 1 - 0.5,
                        speedY: Math.random() * 1 - 0.5
                    });
                }
                
                function animate() {
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                    
                    for (let i = 0; i < particles.length; i++) {
                        const p = particles[i];
                        
                        ctx.fillStyle = 'rgba(255, 255, 255, 0.8)';
                        ctx.beginPath();
                        ctx.arc(p.x, p.y, p.size, 0, Math.PI * 2);
                        ctx.fill();
                        
                        p.x += p.speedX;
                        p.y += p.speedY;
                        
                        if (p.x < 0 || p.x > canvas.width) p.speedX *= -1;
                        if (p.y < 0 || p.y > canvas.height) p.speedY *= -1;
                    }
                    
                    requestAnimationFrame(animate);
                }
                
                animate();
                
            } else if (bgType === 'waves') {
                // 波浪效果预览
                preview.style.background = `linear-gradient(135deg, ${color1}, ${color2})`;
                const canvas = document.createElement('canvas');
                canvas.width = preview.offsetWidth;
                canvas.height = preview.offsetHeight;
                preview.appendChild(canvas);
                
                const ctx = canvas.getContext('2d');
                let time = 0;
                
                function animate() {
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                    
                    ctx.fillStyle = 'rgba(255, 255, 255, 0.2)';
                    ctx.beginPath();
                    
                    for (let x = 0; x < canvas.width; x++) {
                        const y = Math.sin(x * 0.02 + time) * 10 + canvas.height / 2;
                        if (x === 0) {
                            ctx.moveTo(x, y);
                        } else {
                            ctx.lineTo(x, y);
                        }
                    }
                    
                    ctx.lineTo(canvas.width, canvas.height);
                    ctx.lineTo(0, canvas.height);
                    ctx.closePath();
                    ctx.fill();
                    
                    time += 0.1;
                    requestAnimationFrame(animate);
                }
                
                animate();
                
            } else if (bgType === 'stars') {
                // 星空效果预览
                preview.style.background = `linear-gradient(135deg, ${color1}, ${color2})`;
                const canvas = document.createElement('canvas');
                canvas.width = preview.offsetWidth;
                canvas.height = preview.offsetHeight;
                preview.appendChild(canvas);
                
                const ctx = canvas.getContext('2d');
                const stars = [];
                
                for (let i = 0; i < 30; i++) {
                    stars.push({
                        x: Math.random() * canvas.width,
                        y: Math.random() * canvas.height,
                        size: Math.random() * 2 + 0.5,
                        alpha: Math.random() * 0.8 + 0.2
                    });
                }
                
                function animate() {
                    ctx.clearRect(0, 0, canvas.width, canvas.height);
                    
                    for (let i = 0; i < stars.length; i++) {
                        const star = stars[i];
                        
                        ctx.fillStyle = `rgba(255, 255, 255, ${star.alpha})`;
                        ctx.beginPath();
                        ctx.arc(star.x, star.y, star.size, 0, Math.PI * 2);
                        ctx.fill();
                        
                        // 让星星闪烁
                        star.alpha += (Math.random() * 0.1 - 0.05);
                        if (star.alpha < 0.2) star.alpha = 0.2;
                        if (star.alpha > 1) star.alpha = 1;
                    }
                    
                    requestAnimationFrame(animate);
                }
                
                animate();
            }
        }
        
        // 页面加载时初始化
        document.addEventListener('DOMContentLoaded', function() {
            // 添加动画效果
            setTimeout(() => {
                document.querySelectorAll('.stat-card').forEach((card, index) => {
                    card.style.animation = `fadeIn 0.4s ease ${index * 0.1}s forwards`;
                    card.style.opacity = '0';
                });
            }, 100);
            
            // 初始化背景预览
            updateBgPreview();
        });
    </script>
</body>
</html>